uniform sampler2D uni_smp_gb1 ;
uniform sampler2D uni_smp_gb2 ;
uniform sampler2D uni_smp_gb3 ;
uniform sampler2D uni_smp_gb4 ;

/// Gives the birghtness of the background an extra hit
uniform float uni_beat ;

uniform vec3 uni_bottom_color ; // the bottom color, should stay constant.
uniform vec3 uni_sky_color_1 ; // used through out the demo
uniform vec3 uni_sky_color_2 ; // used at the end in the outro

/// Used for mixing the sky color 1 with sky color2
uniform float uni_mix_color_1_2 ;

//vec4 color_bg1_1 = vec4(0.0,0.0,0.2,1.0) ;
//vec4 color_bg1_2 = vec4(0.4,0.4,1.0,1.0) ;


void main()
{
	
	vec3 t = vec3( texture2D(uni_smp_gb4, gl_TexCoord[0].xy) ) ;

	vec4 sky_color = mix(vec4(uni_sky_color_1,1.0), vec4(uni_sky_color_2,1.0), uni_mix_color_1_2) ;
	vec4 bottom_color = mix(vec4(uni_bottom_color,1.0), vec4(uni_sky_color_2,1.0), uni_mix_color_1_2) ;

	gl_FragColor = vec4(smoothstep(0.0,1.0,uni_beat)*0.2)+mix(bottom_color, sky_color, vec4(t,1.0)) ;
	//gl_FragColor = smoothstep(vec4(0.0),vec4(1.0),gl_FragColor) ;
	
}